package com.qboxus.tictic.activitesfragments.livestreaming.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.databinding.DataBindingUtil;

import com.qboxus.tictic.R;
import com.qboxus.tictic.activitesfragments.livestreaming.model.LiveUserModel;
import com.qboxus.tictic.databinding.FragmentPkBattleInviteSendBinding;
import com.qboxus.tictic.interfaces.FragmentCallBack;
import com.qboxus.tictic.simpleclasses.Functions;
import com.qboxus.tictic.simpleclasses.Variables;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;

public class PkBattleInviteSendFragment extends BottomSheetDialogFragment implements View.OnClickListener {

    FragmentPkBattleInviteSendBinding binding;
    FragmentCallBack fragmentCallBack;
    DatabaseReference rootref;
    LiveUserModel liveUserModel;
    String streamingId;

    public PkBattleInviteSendFragment(FragmentCallBack fragmentCallBack) {
        this.fragmentCallBack = fragmentCallBack;
    }

    public static PkBattleInviteSendFragment newInstance(String streamingId, LiveUserModel liveUserModel, FragmentCallBack fragmentCallBack) {
        PkBattleInviteSendFragment fragment = new PkBattleInviteSendFragment(fragmentCallBack);
        Bundle args = new Bundle();
        args.putParcelable("data", liveUserModel);
        args.putSerializable("streamingId", streamingId);
        fragment.setArguments(args);
        return fragment;
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment

        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_pk_battle_invite_send, container, false);

        rootref = FirebaseDatabase.getInstance().getReference();

        Bundle bundle = getArguments();

        liveUserModel = bundle.getParcelable("data");
        streamingId = bundle.getString("streamingId");

        binding.myImage.setController(Functions.frescoImageLoad(Functions.getSharedPreference(getContext()).getString(Variables.U_PIC, ""), binding.myImage, false));

        binding.otherImage.setController(Functions.frescoImageLoad(liveUserModel.getUserPicture(), binding.otherImage, false));

        binding.cancelBtn.setOnClickListener(this);


        return binding.getRoot();
    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.cancelBtn:
                rootref.child("LiveStreamingUsers").child(liveUserModel.streamingId).child("pkInvitation").removeValue();
                rootref.child("LiveStreamingUsers").child(streamingId).child("pkInvitation").removeValue();

                break;
        }
    }
}